' Hangman for CMM2
' Rev 1.0.0 William M Leue 7/10/2021

option default integer
option base 1

const NWORDS = 3000
const MIN_WORD_LEN = 4
const MAX_WORD_LEN = 10
const NUM_LEVELS = 3
const NMENU = 3

const SCAFF_HEIGHT = 400
const SCAFF_BASE_HEIGHT = 100
const SCAFF_BASE_WIDTH = 150
const SCAFF_ARM_LENGTH = 110
const SCAFF_ARM_HEIGHT = 40
const SCAFF_POLE_THICK = 8
const SCAFF_ARM_THICK = 3
const SCAFF_X = 100
const SCAFF_Y = 50

const HM_EYE_XOFF   = 10
const HM_EYE_YOFF   = 15
const HM_EYE_RAD    =  3
const HM_MOUTH_HLEN =  6
const HM_MOUTH_YOFF = 28

const HM_HEAD_RAD =   20
const HM_BODY_LEN =   70
const HM_ARM_LEN  =   40
const HM_ARM_YSTART = 2*HM_HEAD_RAD+10
const HM_ARM_DROP =   20
const HM_ARM_SPREAD = 30 
const HM_LEG_LEN  =   40
const HM_LEG_DROP =   30
const HM_LEG_SPREAD = 30
const HM_HAND_LEN =    8
const HM_FOOT_LEN =    8

const BLANKS_X = 50
const BLANKS_Y = 500
const BLANKS_LEN = 40
const BLANKS_GAP = 10

const PROMPT_X = 400
const PROMPT_Y = 200
const ANSWER_X = 400
const ANSWER_Y = 270
const USED_X   = 400
const USED_Y   = 400

const GOOD_GUESS = 1
const BAD_GUESS  = 2
const WON_GAME   = 3
const LOST_GAME  = 4

const UP    = 128
const DOWN  = 129
const LEFT  = 130
const RIGHT = 131
const ENTER = 13

' Globals
dim words$(NWORDS)
the_word$ = ""
dim revealed(MAX_WORD_LEN)
running = 0
solved = 0
hanged = 0
num_guesses = 0
dim used_letters(26)
dim ldata(3, NUM_LEVELS) = (3, 5, 10, 4, 6, 8, 5, 10, 6)
dim nchoice(NMENU) = (3, 2, 1)
dim level = 1
dim wchoice = 1
dim level_names$(NUM_LEVELS) = ("Easy", "Medium", "Hard")
dim wchoice_names$(2) = ("Computer Picks", "You Pick")

' Main Program
open "debug.txt" for output as #1
ReadWords
do
  HandleMenuEvents
  if running then
    NewGame
    HandleGameEvents
  end if
loop
end

' Handle events for the Main Menu
sub HandleMenuEvents
  local z$
  local cmd, item
  DrawMenu
  item = 1
  HiliteMenu item, rgb(red)
  do
    z$ = INKEY$
    do
      z$ = INKEY$
    loop until z$ <> ""
    cmd = asc(z$)
    select case cmd
      case UP
        if item > 1 then
          item = item-1
        else
          item = NMENU
        end if
      case DOWN
        if item < NMENU then
          item = item+1
        else
          item = 1
        end if
      case LEFT
        select case item
          case 1
            if level > 1 then
              level = level-1
            else
              level = 3
            end if
          case 2
            wchoice = 3 - wchoice
          case 3
            cls
            end
        end select
      case RIGHT
        select case item
          case 1
            if level < 3 then
              level = level+1
            else
              level = 1
            end if
          case 2
            wchoice= 3 - wchoice
          case 3
            cls
            end
        end select
      case ENTER
        select case item
          case 1 to 2
            running = 1
            exit do
          case 3
            cls
            end
        end select
    end select
    DrawMenu
    HiliteMenu prev_item, rgb(black)
    HiliteMenu item, rgb(red)
    prev_item = item
  loop    
end sub

sub HiliteMenu item, c
  local x, y, xv(3), yv(3)
  x = 38
  y = 100 + (item-1)*50
  xv(1) = x : yv(1) = y
  xv(2) = x-10 : yv(2) = y-10
  xv(3) = x-10 : yv(3) = y+10
  polygon 3, xv(), yv(), c, c
end sub

' Draw the Menu
sub DrawMenu
  local x, y
  local m$
  cls
  text MM.HRES\2, 40, "Hangman!", "CT", 5
  x = 40 : y = 100
  m$ = level_names$(level)
  text x, y, "Choose Level: "
  text x+120, y, m$,,,, rgb(green)
  m$ = "Word Length: " + str$(ldata(1, level)) + " to " + str$(ldata(2, level))
  m$ = m$ + " Num Guesses: " + str$(ldata(3, level))
  text x+30, y+20, m$
  inc y, 50
  m$ = wchoice_names$(wchoice)
  text x, y, "Words for Guessing: "
  text x+170, y, m$,,,, rgb(green)
  inc y, 50
  text x, y, "Quit"
  y = 500
  text x, y, "Use UP and DOWN Arrow keys to choose Item"
  text x, y+20, "Use LEFT and Right Arrow keys to make choice"
  text x, y+40, "Press ENTER to accept choices and PLAY"
end sub

' Start a New Game
sub NewGame
  local i, ok
  solved = 0
  hanged = 0
  num_guesses = 0
  for i = 1 to 26
    used_letters(i) = 0
  next i
  for i = 1 to MAX_WORD_LEN
    revealed(i) = 0
  next i
  ok = 1
  if wchoice = 1 then
    PickWord
  else
    UserPickWord ok
  end if
  if not ok then running = 0
  DrawScaffold
  DrawWord
end sub

' Read in the list of words
sub ReadWords
  local i
  open "3000Words.txt" for input as #2
  for i = 1 to NWORDS
    line input #2, words$(i)
  next i
  close #2
end sub

' Draw the Scaffold
sub DrawScaffold
  local px, ph
  cls
  px = SCAFF_X + SCAFF_ARM_LENGTH
  ph = SCAFF_HEIGHT - SCAFF_BASE_HEIGHT
  line SCAFF_X, SCAFF_Y, px, SCAFF_Y, SCAFF_ARM_THICK
  line SCAFF_X, SCAFF_Y, SCAFF_X, SCAFF_Y+SCAFF_ARM_HEIGHT, SCAFF_ARM_THICK
  line px, SCAFF_Y, px, ph, SCAFF_POLE_THICK
  box px - SCAFF_BASE_WIDTH\2, ph, SCAFF_BASE_WIDTH, SCAFF_BASE_HEIGHT, SCAFF_POLE_THICK
end sub

' Draw the Word to guess
' Known letters are filled in.
' If lose = 1, show all letters with ones not guessed in red.
' If solved = 1, show all letters in green.
sub DrawWord
  local i, x, y
  local c$
  y = BLANKS_Y
  for i = 1 to len(the_word$)
    x = BLANKS_X + (i-1)*(BLANKS_LEN+BLANKS_GAP)    
    c$ = MID$(the_word$, i, 1)
    line x, y, x+BLANKS_LEN, y
    col = RGB(WHITE)
    if hanged and not revealed(i) then col = RGB(RED)
    if solved then col = RGB(GREEN)
    if revealed(i) or hanged then
      text x+BLANKS_LEN\2, y-2, c$, "CB", 5,, col
    end if
  next i
end sub

' Pick a random word for guessing
sub PickWord
  local i, k, wl, ok
  do
    ok = 1
    do
      k = NWORDS*rnd()
    loop until k >= 1 and k <= NWORDS
    the_word$ = words$(k)
    wl = len(the_word$)
    if wl < ldata(1, level) or wl > ldata(2, level) then
      ok = 0
    end if
  loop until ok = 1
  the_word$ = UCASE$(the_word$)
end sub

' Let the user pick a word
sub UserPickWord ok
  local w$, z$
  cls
  z$ = INKEY$
  print "Enter Your Word (3 to 10 letters): ";
  input "", w$
  if len(w$) < 3 or len(w$) > 10 then
    print "Oops! Your word '" + w$ + "' is too short or too long!"
    print ""
    print ""
    print "Press Any Key to Continue"
    z$ = INKEY$
    do
      z$ = INKEY$
    loop until z$ <> ""
    ok = 0
    exit sub
  else
    the_word$ = UCASE$(w$)
    ok = 1
  end if
end sub

' Handle events for a game
sub HandleGameEvents
  local z$
  local c$
  local val, ok
  do while running
    do
      z$ = INKEY$
      text PROMPT_X, PROMPT_Y, space$(30)
      text PROMPT_X, PROMPT_Y, "Type Your Guess A-Z: "
      do
        z$ = INKEY$
      loop until z$ <> ""
      val = asc(z$)
      ok = 0
      if val >= asc("a") and val <= asc("z") then ok = 1
      if val >= asc("A") and val <= asc("Z") then ok = 1
      if not ok then Beep
    loop until ok
    EvaluateGuess UCASE$(z$), result
    Answer result, UCASE$(z$)
    ShowUsedLetters
    DrawWord
    if solved or hanged then
      running = 0
      text 100, 598, "Press any Key to Continue", "LB", 3
      z$ = INKEY$
      do
        z$ = INKEY$
      loop until z$ <> ""
    end if
  loop
end sub

' Evaluate a guess and show any guessed letters
' Also update misses, decide if game won or lost
' The result code tells what happened:
'   1: correct guess, game continues
'   2: missed guess, game continues
'   3: correct guess, game WON!
'   4: missed guess, game LOST!
sub EvaluateGuess g$, result
  local i, hit, count, wl, windex
  local c$
  windex = asc(g$) - asc("A") + 1
  used_letters(windex) = 1
  hit = 0
  wl = len(the_word$)
  for i = 1 to wl
    if revealed(i) then continue for
    c$ = MID$(the_word$, i, 1)
    if g$ = c$ then
      revealed(i) = 1
      hit = 1
    endif 
  next i
  if hit = 0 then
    inc num_guesses
    if num_guesses = ldata(3, level) then
      hanged = 1
      result = LOST_GAME
    else
      result = BAD_GUESS
    end if
  else
    count = 0
    for i = 1 to wl
      if revealed(i) then inc count
    next i
    if count = wl then
      solved = 1
      result = WON_GAME
    else
      result = GOOD_GUESS
    end if
  end if
  DrawHangee
if num_guesses = ldata(3, level)-1 then
  save image "Hangman"
end if
end sub

' Beep if an illegal character is pressed
sub Beep
  play sound 1, B, Q, 1000
  pause 100
  play stop
end sub

' Draw the hanged man
sub DrawHangee
  local i, x, y, yt, ye, xt
  x = SCAFF_X
  y = SCAFF_Y + SCAFF_ARM_HEIGHT
  for i = 1 to num_guesses
    select case i
      case 1
        yt = y + HM_HEAD_RAD
        circle x, yt, HM_HEAD_RAD
      case 2
        yt = y + 2*HM_HEAD_RAD
        line x, yt, x, yt+HM_BODY_LEN
      case 3
        yt = y + HM_ARM_YSTART
        ye = yt + HM_ARM_DROP
        xt = x - HM_ARM_SPREAD
        line x, yt, xt, ye
      case 4
        yt = y + HM_ARM_YSTART
        ye = yt + HM_ARM_DROP
        xt = x + HM_ARM_SPREAD
        line x, yt, xt, ye
      case 5
        yt = y + 2*HM_HEAD_RAD + HM_BODY_LEN
        ye = yt + HM_LEG_DROP
        xt = x - HM_LEG_SPREAD
        line x, yt, xt, ye
      case 6
        yt = y + 2*HM_HEAD_RAD + HM_BODY_LEN
        ye = yt + HM_LEG_DROP
        xt = x + HM_LEG_SPREAD
        line x, yt, xt, ye
      case 7
        yt = y + HM_ARM_YSTART
        ye = yt + HM_ARM_DROP
        xt = x - HM_ARM_SPREAD        
        line xt, ye, xt-10, ye-10
      case 8
        yt = y + HM_ARM_YSTART
        ye = yt + HM_ARM_DROP
        xt = x + HM_ARM_SPREAD
        line xt, ye, xt+10, ye-10
      case 9
        yt = y + 2*HM_HEAD_RAD + HM_BODY_LEN
        ye = yt + HM_LEG_DROP
        xt = x - HM_LEG_SPREAD
        line xt, ye, xt-10, ye-10
      case 10
        yt = y + 2*HM_HEAD_RAD + HM_BODY_LEN
        ye = yt + HM_LEG_DROP
        xt = x + HM_LEG_SPREAD
        line xt, ye, xt+10, ye-10
    end select
    DrawFace
  next i
end sub

' Draw the Hangee's face with various expressions
sub DrawFace
  local ex1, ex2, ey, my, mh, mh2
  ex1 = SCAFF_X - HM_EYE_XOFF
  ex2 = SCAFF_X + HM_EYE_XOFF
  ey = SCAFF_Y + SCAFF_ARM_HEIGHT + HM_EYE_YOFF
  my = SCAFF_Y + SCAFF_ARM_HEIGHT + HM_MOUTH_YOFF
  mh = HM_MOUTH_HLEN
  mh2 = HM_MOUTH_HLEN/2
  select case num_guesses
    case 0 to ldata(3, level) - 1
      circle ex1, ey, HM_EYE_RAD
      circle ex2, ey, HM_EYE_RAD
      if solved = 0 then
        line SCAFF_X-mh,  my, SCAFF_X+mh,    my
      else
        arc SCAFF_X, my, mh,, 90, 270
      end if
    case ldata(3, level)
      circle ex1, ey, HM_EYE_RAD,,, rgb(BLACK)
      circle ex2, ey, HM_EYE_RAD,,, rgb(BLACK)
      line ex1-HM_EYE_RAD, ey, ex1+HM_EYE_RAD, ey
      line ex1, ey-HM_EYE_RAD, ex1, ey+HM_EYE_RAD
      line ex2-HM_EYE_RAD, ey, ex2+HM_EYE_RAD, ey
      line ex2, ey-HM_EYE_RAD, ex2, ey+HM_EYE_RAD
  end select
end sub
      
' Tell the user what happened on this move
sub Answer result, c$
  local a$
  text ANSWER_X, ANSWER_Y, space$(40)
  select case result
    case GOOD_GUESS
      a$ = "Good Guess!, '" + c$ + "' is in the Word."
      text ANSWER_X, ANSWER_Y, a$,,,, rgb(green)
    case BAD_GUESS
      a$ = "Nope!, '" + c$ + "' is Not in the Word."
      text ANSWER_X, ANSWER_Y, a$,,,, rgb(red)
    case WON_GAME
      a$ = "Hooray, You Guessed the Word and Won!"
      text ANSWER_X, ANSWER_Y, a$,,,, rgb(green)
    case LOST_GAME
      a$ = "Oops! You ran out of guesses and Lost!"
      text ANSWER_X, ANSWER_Y, a$,,,, rgb(blue)
  end select
  a$ = "You have " + str$(ldata(3, level)-num_guesses) + " Guesses left"
  text ANSWER_X, ANSWER_Y+20, a$
end sub

' Show the letters that have been guessed (right or wrong)
sub ShowUsedLetters
  local i
  local u$, c$
  u$ = ""
  for i = 1 to 26
    if used_letters(i) then
      c$ = chr$(asc("A") + i - 1)
      u$ = u$ + " " + c$
    end if
  next i
  text USED_X, USED_Y, "Used Letters:"
  text USED_X, USED_Y+20, space$(40)
  text USED_X, USED_Y+20, u$
end sub

